/*
 * Decompiled with CFR 0.152.
 */
package piksora.auth;

import java.io.InputStream;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import piksora.auth.AuthResponse;
import piksora.auth.SessionManager;
import piksora.net.ApiClient;

public class AuthService {
    private static final Properties AUTH_PROPERTIES = AuthService.loadAuthProperties();
    private static final Pattern STATUS_PATTERN = Pattern.compile("\"status\"\\s*:\\s*\"([^\"]*)\"", 2);
    private static final Pattern MESSAGE_PATTERN = Pattern.compile("\"message\"\\s*:\\s*\"([^\"]*)\"", 2);
    private static final Pattern TOKEN_PATTERN = Pattern.compile("\"token\"\\s*:\\s*\"([^\"]*)\"", 2);
    private static final Pattern USERNAME_PATTERN = Pattern.compile("\"username\"\\s*:\\s*\"([^\"]*)\"", 2);
    private static final Pattern USER_ID_PATTERN = Pattern.compile("\"user_id\"\\s*:\\s*(\\d+)", 2);
    private static final Pattern EMAIL_PATTERN = Pattern.compile("\"email\"\\s*:\\s*\"([^\"]*)\"", 2);
    private static final Pattern NICKNAME_PATTERN = Pattern.compile("\"nickname\"\\s*:\\s*(?:\"([^\"]*)\"|null)", 2);
    private static final Pattern CREDITS_PATTERN = Pattern.compile("\"credits\"\\s*:\\s*(-?\\d+(?:\\.\\d+)?)", 2);
    private static final Pattern IS_ADMIN_PATTERN = Pattern.compile("\"is_admin\"\\s*:\\s*(\\d+)", 2);
    private static final int DEFAULT_TIMEOUT_MS = AuthService.parseTimeout();

    private AuthService() {
    }

    public static AuthResponse login(String username, String password) {
        String rawPassword;
        AuthResponse response = new AuthResponse();
        String trimmedUser = username != null ? username.trim() : "";
        String string = rawPassword = password != null ? password : "";
        if (trimmedUser.isEmpty() || rawPassword.isEmpty()) {
            response.setSuccess(false);
            response.setMessage("L\u00fctfen kullan\u0131c\u0131 ad\u0131 ve \u015fifre girin.");
            return response;
        }
        try {
            String loginUrl = AuthService.resolveLoginUrl();
            String payload = AuthService.buildJsonPayload(trimmedUser, rawPassword);
            System.out.println("[AUTH] Login iste\u011fi g\u00f6nderiliyor: " + loginUrl);
            String json = ApiClient.postJson(loginUrl, payload, DEFAULT_TIMEOUT_MS);
            if (json == null || json.isEmpty()) {
                response.setSuccess(false);
                response.setMessage("Sunucudan yan\u0131t al\u0131namad\u0131.");
                return response;
            }
            String status = AuthService.extractMatch(STATUS_PATTERN, json);
            if ("success".equalsIgnoreCase(status)) {
                String token = AuthService.extractMatch(TOKEN_PATTERN, json);
                String respUsername = AuthService.extractMatch(USERNAME_PATTERN, json);
                int userId = AuthService.extractInt(USER_ID_PATTERN, json);
                response.setSuccess(true);
                response.setToken(token);
                response.setUsername(respUsername != null ? respUsername : trimmedUser);
                response.setUserId(userId);
                response.setMessage("Giri\u015f ba\u015far\u0131l\u0131.");
                response.setEmail(AuthService.extractMatch(EMAIL_PATTERN, json));
                response.setNickname(AuthService.extractMatch(NICKNAME_PATTERN, json));
                response.setCredits(AuthService.extractDouble(CREDITS_PATTERN, json));
                response.setAdmin(AuthService.extractInt(IS_ADMIN_PATTERN, json) == 1);
                SessionManager.setSession(response);
                System.out.println("[AUTH] Ba\u015far\u0131l\u0131 giri\u015f: " + response.getUsername());
            } else {
                response.setSuccess(false);
                String errorMessage = AuthService.extractMatch(MESSAGE_PATTERN, json);
                response.setMessage(errorMessage != null ? errorMessage : "Ge\u00e7ersiz kullan\u0131c\u0131 ad\u0131 veya \u015fifre.");
                System.err.println("[AUTH] Giri\u015f ba\u015far\u0131s\u0131z: " + response.getMessage());
                SessionManager.clear();
            }
        }
        catch (Exception e) {
            response.setSuccess(false);
            response.setMessage("Sunucuya ba\u011flan\u0131lamad\u0131: " + e.getMessage());
            System.err.println("[AUTH] Sunucu hatas\u0131: " + e.getMessage());
            SessionManager.clear();
        }
        return response;
    }

    private static String buildJsonPayload(String username, String password) {
        return "{" + "\"username\":\"" + AuthService.escapeJson(username) + "\"," + "\"password\":\"" + AuthService.escapeJson(password) + "\"" + "}";
    }

    private static String escapeJson(String value) {
        StringBuilder sb = new StringBuilder();
        char[] cArray = value.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            switch (c) {
                case '\"': {
                    sb.append("\\\"");
                    break;
                }
                case '\\': {
                    sb.append("\\\\");
                    break;
                }
                case '\b': {
                    sb.append("\\b");
                    break;
                }
                case '\f': {
                    sb.append("\\f");
                    break;
                }
                case '\n': {
                    sb.append("\\n");
                    break;
                }
                case '\r': {
                    sb.append("\\r");
                    break;
                }
                case '\t': {
                    sb.append("\\t");
                    break;
                }
                default: {
                    if (c < ' ') {
                        sb.append(String.format("\\u%04x", c));
                        break;
                    }
                    sb.append(c);
                }
            }
            ++n2;
        }
        return sb.toString();
    }

    private static String extractMatch(Pattern pattern, String json) {
        Matcher matcher = pattern.matcher(json);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private static int extractInt(Pattern pattern, String json) {
        Matcher matcher = pattern.matcher(json);
        if (matcher.find()) {
            try {
                return Integer.parseInt(matcher.group(1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    private static double extractDouble(Pattern pattern, String json) {
        Matcher matcher = pattern.matcher(json);
        if (matcher.find()) {
            try {
                return Double.parseDouble(matcher.group(1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0.0;
    }

    private static String resolveLoginUrl() {
        String baseUrl = AUTH_PROPERTIES.getProperty("api.baseUrl", "https://piksora.com");
        String loginPath = AUTH_PROPERTIES.getProperty("api.loginPath", "/api/auth/login.php");
        if (baseUrl.endsWith("/")) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
        }
        if (!loginPath.startsWith("/")) {
            loginPath = "/" + loginPath;
        }
        return String.valueOf(baseUrl) + loginPath;
    }

    private static Properties loadAuthProperties() {
        Properties props = new Properties();
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream is = AuthService.class.getClassLoader().getResourceAsStream("auth.properties");){
                if (is != null) {
                    props.load(is);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            System.err.println("[AUTH] auth.properties okunamad\u0131: " + e.getMessage());
        }
        return props;
    }

    private static int parseTimeout() {
        String timeoutStr = AUTH_PROPERTIES.getProperty("api.timeoutMs", "10000");
        try {
            return Integer.parseInt(timeoutStr);
        }
        catch (NumberFormatException e) {
            return 10000;
        }
    }
}

