/*
 * Decompiled with CFR 0.152.
 */
package piksora.auth;

import piksora.auth.AuthResponse;

public class SessionManager {
    private static String currentUser;
    private static String authToken;
    private static int userId;
    private static String email;
    private static String nickname;
    private static double credits;
    private static boolean admin;

    private SessionManager() {
    }

    public static void setSession(AuthResponse response) {
        if (response == null) {
            SessionManager.clear();
            return;
        }
        currentUser = response.getUsername();
        authToken = response.getToken();
        userId = response.getUserId();
        email = response.getEmail();
        nickname = response.getNickname();
        credits = response.getCredits();
        admin = response.isAdmin();
    }

    public static void clear() {
        currentUser = null;
        authToken = null;
        userId = 0;
        email = null;
        nickname = null;
        credits = 0.0;
        admin = false;
    }

    public static boolean isLoggedIn() {
        return currentUser != null && !currentUser.isEmpty();
    }

    public static String getUser() {
        return currentUser;
    }

    public static String getAuthToken() {
        return authToken;
    }

    public static int getUserId() {
        return userId;
    }

    public static String getEmail() {
        return email;
    }

    public static String getNickname() {
        return nickname;
    }

    public static double getCredits() {
        return credits;
    }

    public static boolean isAdminUser() {
        return admin;
    }
}

