/*
 * Decompiled with CFR 0.152.
 */
package piksora.launcher;

import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import piksora.auth.AuthResponse;
import piksora.auth.AuthService;

public class LoginController {
    @FXML
    private TextField usernameField;
    @FXML
    private PasswordField passwordField;
    @FXML
    private Button loginButton;

    @FXML
    private void handleLogin() {
        String username = this.usernameField.getText();
        String password = this.passwordField.getText();
        if (username == null || username.trim().isEmpty() || password == null || password.isEmpty()) {
            this.showAlert(Alert.AlertType.WARNING, "Eksik Bilgi", "L\u00fctfen kullan\u0131c\u0131 ad\u0131 ve \u015fifre giriniz.");
            return;
        }
        this.loginButton.setDisable(true);
        Thread loginTask = new Thread(() -> {
            AuthResponse authResponse = AuthService.login(username, password);
            Platform.runLater(() -> {
                this.loginButton.setDisable(false);
                if (authResponse.isSuccess()) {
                    this.showAlert(Alert.AlertType.INFORMATION, "Ba\u015far\u0131l\u0131", "Ho\u015f geldiniz " + authResponse.getUsername() + "!");
                } else {
                    this.passwordField.clear();
                    this.showAlert(Alert.AlertType.ERROR, "Giri\u015f Ba\u015far\u0131s\u0131z", authResponse.getMessage());
                }
            });
        }, "login-controller-task");
        loginTask.setDaemon(true);
        loginTask.start();
    }

    private void showAlert(Alert.AlertType type, String title, String message) {
        Alert alert = new Alert(type);
        alert.setTitle(title);
        alert.setHeaderText(null);
        alert.setContentText(message);
        alert.show();
    }
}

