/*
 * Decompiled with CFR 0.152.
 */
package piksora.launcher;

import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.Locale;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.PasswordField;
import javafx.scene.control.Slider;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.stage.Stage;
import piksora.auth.AuthResponse;
import piksora.auth.SessionManager;
import piksora.util.AntiCheatManager;
import piksora.util.UpdateManager;

public class MainPageController {
    @FXML
    private BorderPane rootPane;
    @FXML
    private Button btnHome;
    @FXML
    private Button btnSettings;
    @FXML
    private Button btnAbout;
    @FXML
    private Button btnProfile;
    @FXML
    private Button btnStore;
    @FXML
    private Button btnPlayServer;
    @FXML
    private Button btnExit;
    @FXML
    private Button btnSaveSettings;
    @FXML
    private StackPane server1Container;
    @FXML
    private StackPane server2Container;
    @FXML
    private ImageView server1Image;
    @FXML
    private ImageView server2Image;
    @FXML
    private ImageView userAvatar;
    @FXML
    private Label lblUsername;
    @FXML
    private Label lblOnlineStatus;
    @FXML
    private Label volumeLabel;
    @FXML
    private VBox mainContentPane;
    @FXML
    private VBox settingsPane;
    @FXML
    private VBox profilePane;
    @FXML
    private Slider volumeSlider;
    @FXML
    private ComboBox<String> graphicsComboBox;
    @FXML
    private ComboBox<String> languageComboBox;
    @FXML
    private CheckBox fullscreenCheckBox;
    @FXML
    private CheckBox vsyncCheckBox;
    @FXML
    private CheckBox rememberPasswordCheckBox;
    @FXML
    private Label profileHeaderUsername;
    @FXML
    private Label profileHeaderEmail;
    @FXML
    private Label profileCreditsLabel;
    @FXML
    private Label profileStatusLabel;
    @FXML
    private TextField profileUsernameField;
    @FXML
    private TextField profileEmailField;
    @FXML
    private PasswordField profileCurrentPasswordField;
    @FXML
    private PasswordField profileNewPasswordField;
    @FXML
    private PasswordField profileConfirmPasswordField;
    @FXML
    private Button btnUpdateProfile;
    @FXML
    private Button btnChangePassword;
    @FXML
    private ImageView profileAvatarLarge;
    private Stage stage;
    private String selectedServer = null;
    private DragPosition dragPos = new DragPosition();

    @FXML
    public void initialize() {
        AntiCheatManager.initializeAntiCheat();
        this.checkForUpdatesAsync();
        this.loadImagesAsync();
        this.setupButtonHovers();
        this.applyRoundedCorners(this.server1Image);
        this.applyRoundedCorners(this.server2Image);
        if (this.server1Container != null) {
            this.server1Container.setOnMouseClicked(e -> {
                this.selectedServer = "server1";
                this.highlightSelected(this.server1Container);
                this.resetStyle(this.server2Container);
            });
        }
        if (this.server2Container != null) {
            this.server2Container.setOnMouseClicked(e -> {
                this.selectedServer = "server2";
                this.highlightSelected(this.server2Container);
                this.resetStyle(this.server1Container);
            });
        }
        if (this.btnHome != null) {
            this.btnHome.setOnAction(e -> {
                this.highlightButton(this.btnHome, this.btnSettings, this.btnAbout, this.btnProfile, this.btnStore);
                this.showMainContent();
            });
        }
        if (this.btnSettings != null) {
            this.btnSettings.setOnAction(e -> {
                this.highlightButton(this.btnSettings, this.btnHome, this.btnAbout, this.btnProfile, this.btnStore);
                this.showSettings();
            });
        }
        if (this.btnAbout != null) {
            this.btnAbout.setOnAction(e -> this.highlightButton(this.btnAbout, this.btnHome, this.btnSettings, this.btnProfile, this.btnStore));
        }
        if (this.btnProfile != null) {
            this.btnProfile.setOnAction(e -> {
                this.highlightButton(this.btnProfile, this.btnHome, this.btnSettings, this.btnAbout, this.btnStore);
                this.showProfile();
            });
        }
        if (this.btnStore != null) {
            this.btnStore.setOnAction(e -> this.openWeb("https://piksora.com/store"));
        }
        if (this.btnPlayServer != null) {
            this.btnPlayServer.setOnAction(e -> {
                if (this.selectedServer != null) {
                    this.launchClient(this.selectedServer);
                } else {
                    System.out.println("L\u00fctfen bir sunucu se\u00e7in!");
                }
            });
        }
        if (this.btnExit != null) {
            this.btnExit.setOnAction(e -> {
                System.out.println("[EXIT] Uygulama kapat\u0131l\u0131yor...");
                this.stage.close();
            });
        }
        this.initializeSettings();
        if (this.btnSaveSettings != null) {
            this.btnSaveSettings.setOnAction(e -> this.saveSettings());
        }
        if (this.btnUpdateProfile != null) {
            this.btnUpdateProfile.setOnAction(e -> {
                this.openWeb("https://piksora.com/profile");
                this.setProfileStatus("Profil g\u00fcncellemesi web sitesinden yap\u0131lmaktad\u0131r.", Color.LIGHTGREEN);
            });
        }
        if (this.btnChangePassword != null) {
            this.btnChangePassword.setOnAction(e -> {
                this.openWeb("https://piksora.com/profile#password");
                this.clearProfilePasswordFields();
                this.setProfileStatus("\u015eifre de\u011fi\u015fikli\u011fi i\u00e7in web sitesine y\u00f6nlendirildiniz.", Color.LIGHTGREEN);
            });
        }
        this.setupWindowDrag();
        this.setupOvalCorners();
        this.populateProfileFromSession();
    }

    private void initializeSettings() {
        if (this.volumeSlider != null && this.volumeLabel != null) {
            this.volumeSlider.valueProperty().addListener((obs, oldVal, newVal) -> {
                int volume = newVal.intValue();
                this.volumeLabel.setText(String.valueOf(volume) + "%");
            });
        }
        if (this.graphicsComboBox != null) {
            this.graphicsComboBox.setItems(FXCollections.observableArrayList((Object[])new String[]{"D\u00fc\u015f\u00fck", "Orta", "Y\u00fcksek", "\u00c7ok Y\u00fcksek", "Otomatik"}));
            this.graphicsComboBox.setValue((Object)"Orta");
            this.graphicsComboBox.setStyle("-fx-background-color: rgba(50, 50, 50, 0.9);");
            this.graphicsComboBox.setCellFactory(listView -> {
                ListCell<String> cell = new ListCell<String>(){

                    protected void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty || item == null) {
                            this.setText(null);
                        } else {
                            this.setText(item);
                            this.setTextFill((Paint)Color.WHITE);
                            this.setStyle("-fx-background-color: rgba(50, 50, 50, 0.9);");
                        }
                    }
                };
                return cell;
            });
            this.graphicsComboBox.setButtonCell((ListCell)new ListCell<String>(){

                protected void updateItem(String item, boolean empty) {
                    super.updateItem((Object)item, empty);
                    if (empty || item == null) {
                        this.setText(null);
                    } else {
                        this.setText(item);
                        this.setTextFill((Paint)Color.WHITE);
                    }
                }
            });
        }
        if (this.languageComboBox != null) {
            this.languageComboBox.setItems(FXCollections.observableArrayList((Object[])new String[]{"T\u00fcrk\u00e7e", "English"}));
            this.languageComboBox.setValue((Object)"T\u00fcrk\u00e7e");
            this.languageComboBox.setStyle("-fx-background-color: rgba(50, 50, 50, 0.9);");
            this.languageComboBox.setCellFactory(listView -> {
                ListCell<String> cell = new ListCell<String>(){

                    protected void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty || item == null) {
                            this.setText(null);
                        } else {
                            this.setText(item);
                            this.setTextFill((Paint)Color.WHITE);
                            this.setStyle("-fx-background-color: rgba(50, 50, 50, 0.9);");
                        }
                    }
                };
                return cell;
            });
            this.languageComboBox.setButtonCell((ListCell)new ListCell<String>(){

                protected void updateItem(String item, boolean empty) {
                    super.updateItem((Object)item, empty);
                    if (empty || item == null) {
                        this.setText(null);
                    } else {
                        this.setText(item);
                        this.setTextFill((Paint)Color.WHITE);
                    }
                }
            });
        }
    }

    private void showSettings() {
        if (this.mainContentPane != null) {
            this.mainContentPane.setVisible(false);
            this.mainContentPane.setManaged(false);
        }
        this.hideProfilePane();
        if (this.settingsPane != null) {
            this.settingsPane.setVisible(true);
            this.settingsPane.setManaged(true);
        }
    }

    private void showMainContent() {
        this.hideProfilePane();
        if (this.settingsPane != null) {
            this.settingsPane.setVisible(false);
            this.settingsPane.setManaged(false);
        }
        if (this.mainContentPane != null) {
            this.mainContentPane.setVisible(true);
            this.mainContentPane.setManaged(true);
        }
    }

    private void showProfile() {
        if (this.mainContentPane != null) {
            this.mainContentPane.setVisible(false);
            this.mainContentPane.setManaged(false);
        }
        if (this.settingsPane != null) {
            this.settingsPane.setVisible(false);
            this.settingsPane.setManaged(false);
        }
        if (this.profilePane != null) {
            this.profilePane.setVisible(true);
            this.profilePane.setManaged(true);
            this.clearProfileStatus();
            this.clearProfilePasswordFields();
            this.populateProfileFromSession();
        }
    }

    private void hideProfilePane() {
        if (this.profilePane != null) {
            this.profilePane.setVisible(false);
            this.profilePane.setManaged(false);
        }
    }

    private void saveSettings() {
        System.out.println("[SETTINGS] Ayarlar kaydediliyor...");
        if (this.volumeSlider != null) {
            System.out.println("[SETTINGS] Ses seviyesi: " + (int)this.volumeSlider.getValue() + "%");
        }
        if (this.graphicsComboBox != null) {
            System.out.println("[SETTINGS] Grafik kalitesi: " + (String)this.graphicsComboBox.getValue());
        }
        if (this.languageComboBox != null) {
            System.out.println("[SETTINGS] Dil: " + (String)this.languageComboBox.getValue());
        }
        if (this.fullscreenCheckBox != null) {
            System.out.println("[SETTINGS] Tam ekran: " + this.fullscreenCheckBox.isSelected());
        }
        if (this.vsyncCheckBox != null) {
            System.out.println("[SETTINGS] VSync: " + this.vsyncCheckBox.isSelected());
        }
        if (this.rememberPasswordCheckBox != null) {
            System.out.println("[SETTINGS] \u015eifre hat\u0131rla: " + this.rememberPasswordCheckBox.isSelected());
        }
        Alert alert = new Alert(Alert.AlertType.INFORMATION);
        alert.setTitle("Ba\u015far\u0131l\u0131");
        alert.setHeaderText(null);
        alert.setContentText("Ayarlar ba\u015far\u0131yla kaydedildi!");
        alert.showAndWait();
    }

    private void clearProfileStatus() {
        if (this.profileStatusLabel != null) {
            this.profileStatusLabel.setText("");
            this.profileStatusLabel.setTextFill((Paint)Color.web((String)"#ffaa00"));
        }
    }

    private void setProfileStatus(String message, Color color) {
        if (this.profileStatusLabel != null) {
            this.profileStatusLabel.setText(message != null ? message : "");
            if (color != null) {
                this.profileStatusLabel.setTextFill((Paint)color);
            }
        }
    }

    private void clearProfilePasswordFields() {
        if (this.profileCurrentPasswordField != null) {
            this.profileCurrentPasswordField.clear();
        }
        if (this.profileNewPasswordField != null) {
            this.profileNewPasswordField.clear();
        }
        if (this.profileConfirmPasswordField != null) {
            this.profileConfirmPasswordField.clear();
        }
    }

    private void populateProfileFromSession() {
        String emailDisplay;
        String displayName;
        if (!SessionManager.isLoggedIn()) {
            return;
        }
        String username = this.safeTrim(SessionManager.getUser());
        String nickname = this.safeTrim(SessionManager.getNickname());
        String email = this.safeTrim(SessionManager.getEmail());
        double credits = SessionManager.getCredits();
        String string = !nickname.isEmpty() ? nickname : (displayName = !username.isEmpty() ? username : "Oyuncu");
        if (this.lblUsername != null) {
            this.lblUsername.setText(displayName);
        }
        if (this.profileHeaderUsername != null) {
            this.profileHeaderUsername.setText(displayName);
        }
        if (this.profileUsernameField != null) {
            this.profileUsernameField.setText(username);
        }
        String string2 = emailDisplay = !email.isEmpty() ? email : "Email belirtilmedi";
        if (this.profileHeaderEmail != null) {
            this.profileHeaderEmail.setText(emailDisplay);
        }
        if (this.profileEmailField != null) {
            this.profileEmailField.setText(!email.isEmpty() ? email : "");
        }
        if (this.profileCreditsLabel != null) {
            this.profileCreditsLabel.setText(this.formatCredits(credits));
        }
        if (this.lblOnlineStatus != null) {
            this.lblOnlineStatus.setText("Online");
            this.lblOnlineStatus.setTextFill((Paint)Color.web((String)"#00ff00"));
        }
    }

    private String formatCredits(double creditsValue) {
        if (Math.abs(creditsValue - Math.rint(creditsValue)) < 1.0E-4) {
            return String.format(Locale.US, "%.0f PK", creditsValue);
        }
        return String.format(Locale.US, "%.2f PK", creditsValue);
    }

    private void setupOvalCorners() {
        if (this.rootPane != null) {
            Rectangle clip = new Rectangle(1200.0, 700.0);
            clip.setArcWidth(40.0);
            clip.setArcHeight(40.0);
            this.rootPane.setClip((Node)clip);
        }
    }

    private void loadImagesAsync() {
        new Thread(() -> {
            try {
                Image img1 = new Image("http://piksora.com/api/hub.png", 600.0, 180.0, false, true, true);
                Image img2 = new Image("http://piksora.com/api/smp.png", 600.0, 180.0, false, true, true);
                Platform.runLater(() -> {
                    if (this.server1Image != null && !img1.isError()) {
                        this.server1Image.setImage(img1);
                        this.applyRoundedCorners(this.server1Image);
                    }
                    if (this.server2Image != null && !img2.isError()) {
                        this.server2Image.setImage(img2);
                        this.applyRoundedCorners(this.server2Image);
                    }
                });
            }
            catch (Exception e) {
                System.err.println("G\u00f6rsel y\u00fcklenemedi: " + e.getMessage());
            }
        }).start();
    }

    private void setupButtonHovers() {
        if (this.btnHome != null) {
            this.btnHome.setOnMouseEntered(e -> this.btnHome.setStyle("-fx-background-color: #FF8C55; -fx-background-radius: 10; -fx-text-fill: white; -fx-font-size: 15px; -fx-font-weight: bold; -fx-cursor: hand;"));
            this.btnHome.setOnMouseExited(e -> this.btnHome.setStyle("-fx-background-color: #FF6B3D; -fx-background-radius: 10; -fx-text-fill: white; -fx-font-size: 15px; -fx-font-weight: bold; -fx-cursor: hand;"));
        }
        String hoverStyle = "-fx-background-color: rgba(60, 60, 60, 0.9); -fx-background-radius: 10; -fx-text-fill: white; -fx-font-size: 15px; -fx-cursor: hand;";
        String normalStyle = "-fx-background-color: rgba(40, 40, 40, 0.8); -fx-background-radius: 10; -fx-text-fill: #c9d1d9; -fx-font-size: 15px; -fx-cursor: hand;";
        this.applyHoverEffects(this.btnSettings, normalStyle, hoverStyle);
        this.applyHoverEffects(this.btnAbout, normalStyle, hoverStyle);
        this.applyHoverEffects(this.btnProfile, normalStyle, hoverStyle);
        this.applyHoverEffects(this.btnStore, normalStyle, hoverStyle);
        if (this.btnPlayServer != null) {
            this.btnPlayServer.setOnMouseEntered(e -> this.btnPlayServer.setStyle("-fx-background-color: linear-gradient(to right, #FF8C55, #FFB066); -fx-background-radius: 32; -fx-text-fill: white; -fx-font-size: 17px; -fx-font-weight: bold; -fx-cursor: hand; -fx-effect: dropshadow(gaussian, rgba(0,0,0,0.4), 18, 0.3, 0, 8);"));
            this.btnPlayServer.setOnMouseExited(e -> this.btnPlayServer.setStyle("-fx-background-color: linear-gradient(to right, #FF6B3D, #FF9248); -fx-background-radius: 32; -fx-text-fill: white; -fx-font-size: 17px; -fx-font-weight: bold; -fx-cursor: hand; -fx-effect: dropshadow(gaussian, rgba(0,0,0,0.35), 15, 0.25, 0, 6);"));
        }
        if (this.btnExit != null) {
            this.btnExit.setOnMouseEntered(e -> this.btnExit.setStyle("-fx-background-color: rgba(255,0,0,0.8); -fx-background-radius: 15; -fx-text-fill: white; -fx-font-size: 18px; -fx-font-weight: bold; -fx-cursor: hand;"));
            this.btnExit.setOnMouseExited(e -> this.btnExit.setStyle("-fx-background-color: rgba(220,53,69,0.7); -fx-background-radius: 15; -fx-text-fill: white; -fx-font-size: 18px; -fx-font-weight: bold; -fx-cursor: hand;"));
        }
    }

    private void applyHoverEffects(Button button, String normalStyle, String hoverStyle) {
        if (button != null) {
            button.setOnMouseEntered(e -> button.setStyle(hoverStyle));
            button.setOnMouseExited(e -> button.setStyle(normalStyle));
        }
    }

    private void setupWindowDrag() {
        if (this.stage == null || this.rootPane == null) {
            System.out.println("[DRAG] Stage veya rootPane null - drag ayarlanamad\u0131");
            return;
        }
        System.out.println("[DRAG] Pencere s\u00fcr\u00fckleme \u00f6zelli\u011fi ayarlan\u0131yor...");
        this.rootPane.setOnMousePressed(e -> {
            if (this.stage != null) {
                this.dragPos.x = this.stage.getX() - e.getScreenX();
                this.dragPos.y = this.stage.getY() - e.getScreenY();
                System.out.println("[DRAG] Mouse bas\u0131ld\u0131 - X: " + this.dragPos.x + ", Y: " + this.dragPos.y);
            }
        });
        this.rootPane.setOnMouseDragged(e -> {
            if (this.stage != null) {
                this.stage.setX(e.getScreenX() + this.dragPos.x);
                this.stage.setY(e.getScreenY() + this.dragPos.y);
            }
        });
        Node topNode = this.rootPane.getTop();
        if (topNode != null) {
            topNode.setOnMousePressed(e -> {
                if (this.stage != null) {
                    this.dragPos.x = this.stage.getX() - e.getScreenX();
                    this.dragPos.y = this.stage.getY() - e.getScreenY();
                }
            });
            topNode.setOnMouseDragged(e -> {
                if (this.stage != null) {
                    this.stage.setX(e.getScreenX() + this.dragPos.x);
                    this.stage.setY(e.getScreenY() + this.dragPos.y);
                }
            });
        }
        System.out.println("[DRAG] \u2713 Pencere s\u00fcr\u00fckleme \u00f6zelli\u011fi aktif");
    }

    public void setStage(Stage stage) {
        this.stage = stage;
        if (this.rootPane != null && stage != null) {
            this.setupWindowDrag();
        }
    }

    public void initializeSession(AuthResponse authResponse) {
        String skinTarget;
        String displayName;
        if (authResponse == null) {
            this.populateProfileFromSession();
            return;
        }
        String username = this.safeTrim(authResponse.getUsername());
        String nickname = this.safeTrim(authResponse.getNickname());
        String string = !nickname.isEmpty() ? nickname : (displayName = !username.isEmpty() ? username : "Oyuncu");
        if (this.lblUsername != null) {
            this.lblUsername.setText(displayName);
        }
        if (this.profileHeaderUsername != null) {
            this.profileHeaderUsername.setText(displayName);
        }
        if (this.profileUsernameField != null) {
            this.profileUsernameField.setText(username);
        }
        String emailFromResponse = this.safeTrim(authResponse.getEmail());
        if (this.profileHeaderEmail != null) {
            if (!emailFromResponse.isEmpty()) {
                this.profileHeaderEmail.setText(emailFromResponse);
            } else if (this.isLabelEmpty(this.profileHeaderEmail)) {
                this.profileHeaderEmail.setText("Email belirtilmedi");
            }
        }
        if (this.profileEmailField != null) {
            if (!emailFromResponse.isEmpty()) {
                this.profileEmailField.setText(emailFromResponse);
            } else if (this.profileEmailField.getText() == null || this.profileEmailField.getText().isEmpty()) {
                this.profileEmailField.clear();
            }
        }
        if (this.profileCreditsLabel != null) {
            this.profileCreditsLabel.setText(this.formatCredits(authResponse.getCredits()));
        }
        if (this.lblOnlineStatus != null) {
            this.lblOnlineStatus.setText("Online");
            this.lblOnlineStatus.setTextFill((Paint)Color.web((String)"#00ff00"));
        }
        String string2 = skinTarget = !nickname.isEmpty() ? nickname : username;
        if (!skinTarget.isEmpty()) {
            this.loadMinecraftSkin(skinTarget);
        }
        this.populateProfileFromSession();
    }

    private void loadMinecraftSkin(String username) {
        if (this.userAvatar == null) {
            return;
        }
        String skinUrl = "https://minotar.net/helm/" + username + "/64.png";
        System.out.println("[SKIN] Minecraft skin y\u00fckleniyor: " + skinUrl);
        Image skinImage = new Image(skinUrl, 50.0, 50.0, true, true, true);
        skinImage.progressProperty().addListener((obs, oldVal, newVal) -> {
            if (newVal.doubleValue() == 1.0) {
                if (!skinImage.isError()) {
                    this.userAvatar.setImage(skinImage);
                    if (this.profileAvatarLarge != null) {
                        this.profileAvatarLarge.setImage(skinImage);
                    }
                    System.out.println("[SKIN] Minecraft skin ba\u015far\u0131yla y\u00fcklendi: " + username);
                } else {
                    System.err.println("[SKIN] Minecraft skin y\u00fcklenemedi (hata var): " + username);
                }
            }
        });
        skinImage.errorProperty().addListener((obs, wasError, isError) -> {
            if (isError.booleanValue()) {
                System.err.println("[SKIN] Minecraft skin y\u00fcklenirken hata olu\u015ftu: " + username);
                if (skinImage.getException() != null) {
                    System.err.println("[SKIN] Hata detay\u0131: " + skinImage.getException().getMessage());
                }
            }
        });
        if (skinImage.isError()) {
            System.err.println("[SKIN] Minecraft skin an\u0131nda hata verdi: " + username);
        }
    }

    private void applyRoundedCorners(ImageView imageView) {
        double height;
        if (imageView == null) {
            return;
        }
        double width = imageView.getFitWidth() > 0.0 ? imageView.getFitWidth() : imageView.getBoundsInLocal().getWidth();
        double d = height = imageView.getFitHeight() > 0.0 ? imageView.getFitHeight() : imageView.getBoundsInLocal().getHeight();
        if (width <= 0.0 || height <= 0.0) {
            imageView.layoutBoundsProperty().addListener((obs, oldBounds, newBounds) -> {
                if (newBounds.getWidth() > 0.0 && newBounds.getHeight() > 0.0) {
                    this.setImageClip(imageView, newBounds.getWidth(), newBounds.getHeight());
                }
            });
        } else {
            this.setImageClip(imageView, width, height);
        }
    }

    private void setImageClip(ImageView imageView, double width, double height) {
        Rectangle clip = new Rectangle(width, height);
        clip.setArcWidth(36.0);
        clip.setArcHeight(36.0);
        clip.setSmooth(true);
        imageView.setClip((Node)clip);
    }

    private String safeTrim(String value) {
        return value != null ? value.trim() : "";
    }

    private boolean isLabelEmpty(Label label) {
        if (label == null) {
            return true;
        }
        String text = label.getText();
        return text == null || text.trim().isEmpty();
    }

    private void openWeb(String url) {
        try {
            Desktop.getDesktop().browse(new URI(url));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void launchClient(String server) {
        try {
            System.out.println("[LAUNCH] Client ba\u015flat\u0131l\u0131yor: " + server);
            if (!AntiCheatManager.beforeLaunch()) {
                System.err.println("[LAUNCH] Oyun ba\u015flat\u0131lamad\u0131 - anti-cheat sistemi hile tespit etti!");
                Alert alert = new Alert(Alert.AlertType.WARNING);
                alert.setTitle("Hile Tespit Edildi");
                alert.setHeaderText("Oyun Ba\u015flat\u0131lamad\u0131");
                alert.setContentText("Anti-cheat sistemi hile tespit etti. L\u00fctfen \u015f\u00fcpheli eklentileri kald\u0131r\u0131n.");
                alert.showAndWait();
                return;
            }
            String resourcePath = null;
            String clientJar = null;
            String serverName = "";
            if ("server1".equals(server)) {
                resourcePath = "/clients/piksoraclient.jar";
                clientJar = "piksoraclient.jar";
                serverName = "Hub";
            } else if ("server2".equals(server)) {
                resourcePath = "/clients/smpclient.jar";
                clientJar = "smpclient.jar";
                serverName = "SMP";
            } else {
                System.err.println("[LAUNCH] Ge\u00e7ersiz sunucu: " + server);
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.setTitle("Hata");
                alert.setHeaderText("Sunucu Bulunamad\u0131");
                alert.setContentText("Ge\u00e7ersiz sunucu se\u00e7imi!");
                alert.showAndWait();
                return;
            }
            File clientFile = this.extractClientFromResources(resourcePath, clientJar);
            if (clientFile == null || !clientFile.exists()) {
                System.err.println("[LAUNCH] Client dosyas\u0131 \u00e7\u0131kar\u0131lamad\u0131: " + resourcePath);
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.setTitle("Client Bulunamad\u0131");
                alert.setHeaderText("Client Ba\u015flat\u0131lamad\u0131");
                alert.setContentText(String.valueOf(clientJar) + " dosyas\u0131 launcher i\u00e7inde bulunamad\u0131!\n\n" + "L\u00fctfen client JAR dosyalar\u0131n\u0131 \u015fu klas\u00f6re ekleyin:\n" + "src/main/resources/clients/\n\n" + "Gerekli dosyalar:\n" + "\u2022 piksoraclient.jar (Hub i\u00e7in)\n" + "\u2022 smpclient.jar (SMP i\u00e7in)\n\n" + "Dosyalar\u0131 ekledikten sonra projeyi yeniden derleyin:\n" + "mvn clean package");
                alert.setResizable(true);
                alert.getDialogPane().setPrefWidth(500.0);
                alert.showAndWait();
                return;
            }
            if (clientFile.length() < 1000L) {
                System.err.println("[LAUNCH] Client dosyas\u0131 \u00e7ok k\u00fc\u00e7\u00fck, muhtemelen hatal\u0131: " + clientFile.length() + " bytes");
                Alert alert = new Alert(Alert.AlertType.WARNING);
                alert.setTitle("Dosya Hatas\u0131");
                alert.setHeaderText("Client Dosyas\u0131 Hatal\u0131");
                alert.setContentText(String.valueOf(clientJar) + " dosyas\u0131 \u00e7ok k\u00fc\u00e7\u00fck g\u00f6r\u00fcn\u00fcyor (" + clientFile.length() + " bytes).\n\n" + "L\u00fctfen do\u011fru client JAR dosyas\u0131n\u0131 ekledi\u011finizden emin olun.");
                alert.showAndWait();
                return;
            }
            System.out.println("[LAUNCH] " + serverName + " client ba\u015flat\u0131l\u0131yor: " + clientFile.getAbsolutePath());
            String javaHome = System.getProperty("java.home");
            String javaBin = String.valueOf(javaHome) + File.separator + "bin" + File.separator + "java";
            String classPath = clientFile.getAbsolutePath();
            ProcessBuilder processBuilder = new ProcessBuilder(javaBin, "-jar", classPath);
            processBuilder.directory(clientFile.getParentFile());
            Process process = processBuilder.start();
            System.out.println("[LAUNCH] \u2713 " + serverName + " client ba\u015flat\u0131ld\u0131");
            new Thread(() -> {
                try {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    while ((line = reader.readLine()) != null) {
                        System.out.println("[CLIENT] " + line);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }).start();
            new Thread(() -> {
                try {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                    while ((line = reader.readLine()) != null) {
                        System.err.println("[CLIENT-ERROR] " + line);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }).start();
        }
        catch (Exception ex) {
            System.err.println("[LAUNCH] Client ba\u015flatma hatas\u0131: " + ex.getMessage());
            ex.printStackTrace();
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("Hata");
            alert.setHeaderText("Client Ba\u015flat\u0131lamad\u0131");
            alert.setContentText("Client ba\u015flat\u0131l\u0131rken bir hata olu\u015ftu: " + ex.getMessage());
            alert.showAndWait();
        }
    }

    private File extractClientFromResources(String resourcePath, String clientJarName) {
        InputStream inputStream;
        File clientFile;
        block18: {
            boolean created;
            File clientDir;
            String appData = System.getenv("APPDATA");
            if (appData == null) {
                appData = System.getProperty("user.home");
            }
            if (!(clientDir = new File(appData, "PiksoraLauncher" + File.separator + "clients")).exists() && !(created = clientDir.mkdirs())) {
                System.err.println("[EXTRACT] Client dizini olu\u015fturulamad\u0131: " + clientDir.getAbsolutePath());
                clientDir = new File(System.getProperty("user.dir"), "clients");
                clientDir.mkdirs();
            }
            clientFile = new File(clientDir, clientJarName);
            System.out.println("[EXTRACT] Client \u00e7\u0131kar\u0131l\u0131yor: " + resourcePath + " -> " + clientFile.getAbsolutePath());
            inputStream = this.getClass().getResourceAsStream(resourcePath);
            if (inputStream != null) break block18;
            System.err.println("[EXTRACT] \u2717 Resource bulunamad\u0131: " + resourcePath);
            System.err.println("[EXTRACT] L\u00fctfen client JAR dosyalar\u0131n\u0131 src/main/resources/clients/ klas\u00f6r\u00fcne ekleyin:");
            System.err.println("[EXTRACT]   - piksoraclient.jar (Hub i\u00e7in)");
            System.err.println("[EXTRACT]   - smpclient.jar (SMP i\u00e7in)");
            if (clientFile.exists()) {
                System.err.println("[EXTRACT] Eski dosya bulundu ama resource'dan yenisi al\u0131namad\u0131 - siliniyor");
                try {
                    clientFile.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }
        try {
            Throwable throwable = null;
            Object var8_12 = null;
            try (FileOutputStream outputStream = new FileOutputStream(clientFile);){
                int bytesRead;
                byte[] buffer = new byte[8192];
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, bytesRead);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            inputStream.close();
            clientFile.setExecutable(true, false);
            clientFile.setReadable(true, false);
            clientFile.setWritable(true, false);
            System.out.println("[EXTRACT] \u2713 Client ba\u015far\u0131yla \u00e7\u0131kar\u0131ld\u0131: " + clientFile.getAbsolutePath());
            System.out.println("[EXTRACT]   Dosya boyutu: " + clientFile.length() / 1024L + " KB");
            return clientFile;
        }
        catch (Exception e) {
            System.err.println("[EXTRACT] Client \u00e7\u0131karma hatas\u0131: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    private void highlightSelected(StackPane container) {
        if (container != null) {
            container.setStyle("-fx-background-color: rgba(255,107,61,0.92); -fx-background-radius: 26; -fx-cursor: hand; -fx-border-color: #FF8C55; -fx-border-width: 3; -fx-border-radius: 26; -fx-effect: dropshadow(gaussian, rgba(0,0,0,0.48), 28, 0.32, 0, 12); transform: scale(1.02);");
        }
    }

    private void resetStyle(StackPane container) {
        if (container != null) {
            container.setStyle("-fx-background-color: rgba(40, 40, 40, 0.88); -fx-background-radius: 26; -fx-cursor: hand; -fx-effect: dropshadow(gaussian, rgba(0,0,0,0.38), 24, 0.3, 0, 10); transform: scale(1.0);");
        }
    }

    private void highlightButton(Button active, Button ... others) {
        if (active != null) {
            active.setStyle("-fx-background-color: #FF6B3D; -fx-background-radius: 10; -fx-text-fill: white; -fx-font-size: 15px; -fx-font-weight: bold; -fx-cursor: hand;");
        }
        if (others != null) {
            Button[] buttonArray = others;
            int n = others.length;
            int n2 = 0;
            while (n2 < n) {
                Button btn = buttonArray[n2];
                if (btn != null) {
                    btn.setStyle("-fx-background-color: rgba(40, 40, 40, 0.8); -fx-background-radius: 10; -fx-text-fill: #c9d1d9; -fx-font-size: 15px; -fx-cursor: hand;");
                }
                ++n2;
            }
        }
    }

    private void checkForUpdatesAsync() {
        new Thread(() -> {
            try {
                System.out.println("[UPDATE] MainPage g\u00fcncelleme kontrol\u00fc ba\u015flat\u0131l\u0131yor...");
                boolean updateSuccess = UpdateManager.checkForUpdates();
                Platform.runLater(() -> {
                    if (!updateSuccess) {
                        System.out.println("[UPDATE] MainPage g\u00fcncelleme kontrol\u00fc ba\u015far\u0131s\u0131z - devam ediliyor");
                    } else {
                        System.out.println("[UPDATE] MainPage g\u00fcncelleme kontrol\u00fc tamamland\u0131");
                    }
                });
            }
            catch (Exception e) {
                System.err.println("[UPDATE] MainPage g\u00fcncelleme kontrol\u00fc hatas\u0131: " + e.getMessage());
            }
        }).start();
    }

    private static class DragPosition {
        double x;
        double y;

        private DragPosition() {
        }
    }
}

