/*
 * Decompiled with CFR 0.152.
 */
package piksora.launcher.ui;

import javafx.application.HostServices;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.stage.Stage;
import piksora.auth.AuthResponse;
import piksora.auth.AuthService;
import piksora.launcher.MainPageController;
import piksora.util.UpdateManager;

public class LoginView
extends StackPane {
    private final HostServices hostServices;
    private Label errorLabel;
    private VBox loginBox;

    public LoginView(Stage stage, HostServices hostServices) {
        this.hostServices = hostServices;
        this.checkForUpdatesAsync();
        BorderPane leftPanel = new BorderPane();
        leftPanel.setPrefWidth(500.0);
        leftPanel.setPrefHeight(720.0);
        leftPanel.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.rgb((int)50, (int)50, (int)50), new CornerRadii(20.0, 0.0, 0.0, 20.0, false), Insets.EMPTY)}));
        ImageView rightImage = new ImageView();
        try {
            Image img = new Image("https://piksora.com/api/lob.png", 780.0, 720.0, false, true, true);
            rightImage.setImage(img);
            rightImage.setFitWidth(780.0);
            rightImage.setFitHeight(720.0);
            rightImage.setPreserveRatio(false);
            rightImage.setSmooth(true);
        }
        catch (Exception e2) {
            System.err.println("G\u00f6rsel y\u00fcklenemedi: " + e2.getMessage());
        }
        rightImage.setMouseTransparent(true);
        StackPane rightPanel = new StackPane(new Node[]{rightImage});
        rightPanel.setPrefWidth(780.0);
        rightPanel.setPrefHeight(720.0);
        rightPanel.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.rgb((int)30, (int)30, (int)30), new CornerRadii(0.0, 20.0, 20.0, 0.0, false), Insets.EMPTY)}));
        this.loginBox = new VBox(25.0);
        this.loginBox.setAlignment(Pos.CENTER);
        this.loginBox.setPadding(new Insets(40.0, 30.0, 60.0, 30.0));
        VBox logoBox = new VBox(5.0);
        logoBox.setAlignment(Pos.CENTER);
        Label logoLabel = new Label("");
        logoLabel.setTextFill((Paint)Color.WHITE);
        logoLabel.setFont(Font.font((String)"Arial", (double)26.0));
        ImageView logoImageView = new ImageView();
        logoImageView.setVisible(false);
        logoImageView.setManaged(false);
        logoBox.getChildren().addAll((Object[])new Node[]{logoLabel, logoImageView});
        this.loadLogoFromConfig(logoImageView, logoLabel);
        Label title = new Label("GIRIS YAP");
        title.setTextFill((Paint)Color.WHITE);
        title.setFont(Font.font((String)"Arial Bold", (double)32.0));
        TextField usernameField = new TextField();
        usernameField.setPrefWidth(320.0);
        usernameField.setPrefHeight(48.0);
        PasswordField passwordField = new PasswordField();
        passwordField.setPrefWidth(320.0);
        passwordField.setPrefHeight(48.0);
        this.styleField(usernameField, "Kullanici Adi");
        this.styleField((TextField)passwordField, "Sifre");
        Button loginButton = new Button("\u25b6");
        loginButton.setStyle("-fx-background-color: #FF6B3D; -fx-background-radius: 50%; -fx-text-fill: white; -fx-font-size: 28px; -fx-font-weight: bold; -fx-min-width: 70px; -fx-min-height: 70px; -fx-cursor: hand;");
        loginButton.setOnMouseEntered(e -> loginButton.setStyle("-fx-background-color: #FF8C55; -fx-background-radius: 50%; -fx-text-fill: white; -fx-font-size: 28px; -fx-font-weight: bold; -fx-min-width: 70px; -fx-min-height: 70px; -fx-cursor: hand;"));
        loginButton.setOnMouseExited(e -> loginButton.setStyle("-fx-background-color: #FF6B3D; -fx-background-radius: 50%; -fx-text-fill: white; -fx-font-size: 28px; -fx-font-weight: bold; -fx-min-width: 70px; -fx-min-height: 70px; -fx-cursor: hand;"));
        loginButton.setOnAction(e -> {
            String username = usernameField.getText();
            String password = passwordField.getText();
            if (username.isEmpty() || password.isEmpty()) {
                this.showError("L\u00fctfen kullan\u0131c\u0131 ad\u0131 ve \u015fifre giriniz!");
                return;
            }
            this.showInfo("Giri\u015f yap\u0131l\u0131yor...");
            loginButton.setDisable(true);
            usernameField.setDisable(true);
            passwordField.setDisable(true);
            Thread loginTask = new Thread(() -> {
                AuthResponse authResponse = AuthService.login(username, password);
                Platform.runLater(() -> {
                    loginButton.setDisable(false);
                    usernameField.setDisable(false);
                    passwordField.setDisable(false);
                    if (authResponse.isSuccess()) {
                        this.showInfo("Giri\u015f ba\u015far\u0131l\u0131! Y\u00f6nlendiriliyor...");
                        System.out.println("[LOGIN] Ba\u015far\u0131l\u0131 giri\u015f: " + authResponse.getUsername());
                        this.navigateToMainPage(stage, authResponse);
                    } else {
                        this.showError(authResponse.getMessage());
                        passwordField.clear();
                    }
                });
            }, "auth-login-task");
            loginTask.setDaemon(true);
            loginTask.start();
        });
        this.loginBox.getChildren().addAll((Object[])new Node[]{logoBox, title, usernameField, passwordField, loginButton});
        leftPanel.setCenter((Node)this.loginBox);
        Label forgotLabel = new Label("SIFREMI UNUTTUM");
        forgotLabel.setTextFill((Paint)Color.LIGHTGRAY);
        forgotLabel.setStyle("-fx-font-size: 13px; -fx-cursor: hand;");
        forgotLabel.setOnMouseClicked(e -> {
            System.out.println("[LINK] Sifre sifirlama sayfasina yonlendiriliyor...");
            try {
                hostServices.showDocument("https://piksora.com/forgot_password");
            }
            catch (Exception ex) {
                System.err.println("URL a\u00e7ilamadi: " + ex.getMessage());
            }
        });
        forgotLabel.setOnMouseEntered(e -> forgotLabel.setTextFill((Paint)Color.WHITE));
        forgotLabel.setOnMouseExited(e -> forgotLabel.setTextFill((Paint)Color.LIGHTGRAY));
        Label signupLabel = new Label("KAYITLI DEGILIM");
        signupLabel.setTextFill((Paint)Color.LIGHTGRAY);
        signupLabel.setStyle("-fx-font-size: 13px; -fx-cursor: hand;");
        signupLabel.setOnMouseClicked(e -> {
            System.out.println("[LINK] Kayit sayfasina yonlendiriliyor...");
            try {
                hostServices.showDocument("https://piksora.com/register");
            }
            catch (Exception ex) {
                System.err.println("URL a\u00e7ilamadi: " + ex.getMessage());
            }
        });
        signupLabel.setOnMouseEntered(e -> signupLabel.setTextFill((Paint)Color.WHITE));
        signupLabel.setOnMouseExited(e -> signupLabel.setTextFill((Paint)Color.LIGHTGRAY));
        BorderPane linkBar = new BorderPane();
        linkBar.setLeft((Node)forgotLabel);
        linkBar.setRight((Node)signupLabel);
        linkBar.setPadding(new Insets(20.0, 40.0, 40.0, 40.0));
        leftPanel.setBottom((Node)linkBar);
        Button closeButton = new Button("X");
        closeButton.setStyle("-fx-background-color: transparent; -fx-text-fill: white; -fx-font-size: 18px; -fx-font-weight: bold; -fx-min-width: 30px; -fx-min-height: 30px; -fx-cursor: hand;");
        closeButton.setOnMouseEntered(e -> closeButton.setStyle("-fx-background-color: rgba(255,255,255,0.2); -fx-background-radius: 15; -fx-text-fill: white; -fx-font-size: 18px; -fx-font-weight: bold; -fx-min-width: 30px; -fx-min-height: 30px; -fx-cursor: hand;"));
        closeButton.setOnMouseExited(e -> closeButton.setStyle("-fx-background-color: transparent; -fx-text-fill: white; -fx-font-size: 18px; -fx-font-weight: bold; -fx-min-width: 30px; -fx-min-height: 30px; -fx-cursor: hand;"));
        closeButton.setOnAction(e -> {
            System.out.println("[EXIT] Uygulama kapatiliyor...");
            stage.close();
        });
        HBox mainLayout = new HBox();
        mainLayout.getChildren().addAll((Object[])new Node[]{leftPanel, rightPanel});
        mainLayout.setStyle("-fx-background-color: transparent;");
        Rectangle mainClip = new Rectangle();
        mainClip.setArcWidth(40.0);
        mainClip.setArcHeight(40.0);
        mainClip.widthProperty().bind((ObservableValue)mainLayout.widthProperty());
        mainClip.heightProperty().bind((ObservableValue)mainLayout.heightProperty());
        mainLayout.setClip((Node)mainClip);
        this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, CornerRadii.EMPTY, Insets.EMPTY)}));
        Rectangle rootClip = new Rectangle();
        rootClip.setArcWidth(40.0);
        rootClip.setArcHeight(40.0);
        rootClip.widthProperty().bind((ObservableValue)this.widthProperty());
        rootClip.heightProperty().bind((ObservableValue)this.heightProperty());
        this.setClip((Node)rootClip);
        this.getChildren().addAll((Object[])new Node[]{mainLayout, closeButton});
        StackPane.setAlignment((Node)mainLayout, (Pos)Pos.CENTER);
        StackPane.setAlignment((Node)closeButton, (Pos)Pos.TOP_RIGHT);
        StackPane.setMargin((Node)closeButton, (Insets)new Insets(20.0, 20.0, 0.0, 0.0));
        this.setupWindowDrag(stage);
    }

    private void loadLogoFromConfig(ImageView logoImageView, Label fallbackLabel) {
        if (logoImageView == null || fallbackLabel == null) {
            return;
        }
        String logoUrl = "https://piksora.com/api/logo.png";
        if (logoUrl == null || logoUrl.trim().isEmpty()) {
            System.err.println("Logo URL tan\u0131ml\u0131 de\u011fil.");
            return;
        }
        try {
            Image logoImg = new Image(logoUrl, 80.0, 80.0, true, true, true);
            logoImageView.setImage(logoImg);
            logoImageView.setFitWidth(80.0);
            logoImageView.setFitHeight(80.0);
            logoImageView.setPreserveRatio(true);
            logoImageView.setSmooth(true);
            Runnable showLogo = () -> {
                fallbackLabel.setVisible(false);
                fallbackLabel.setManaged(false);
                logoImageView.setVisible(true);
                logoImageView.setManaged(true);
            };
            Runnable showFallback = () -> {
                fallbackLabel.setVisible(true);
                fallbackLabel.setManaged(true);
                logoImageView.setVisible(false);
                logoImageView.setManaged(false);
            };
            logoImg.progressProperty().addListener((obs, oldVal, newVal) -> {
                if (newVal != null && newVal.doubleValue() >= 1.0 && !logoImg.isError()) {
                    Platform.runLater((Runnable)showLogo);
                }
            });
            logoImg.errorProperty().addListener((obs, wasError, isError) -> {
                if (Boolean.TRUE.equals(isError)) {
                    Platform.runLater((Runnable)showFallback);
                    Exception exception = logoImg.getException();
                    if (exception != null) {
                        System.err.println("Logo y\u00fcklenemedi: " + exception.getMessage());
                    }
                }
            });
            if (logoImg.getProgress() >= 1.0 && !logoImg.isError()) {
                showLogo.run();
            }
        }
        catch (Exception e) {
            Platform.runLater(() -> {
                fallbackLabel.setVisible(true);
                fallbackLabel.setManaged(true);
                logoImageView.setVisible(false);
                logoImageView.setManaged(false);
            });
            System.err.println("Logo y\u00fcklenemedi: " + e.getMessage());
        }
    }

    private void setupWindowDrag(Stage stage) {
        DragPosition dragPos = new DragPosition();
        this.setOnMousePressed(e -> {
            dragPosition.x = stage.getX() - e.getScreenX();
            dragPosition.y = stage.getY() - e.getScreenY();
        });
        this.setOnMouseDragged(e -> {
            stage.setX(e.getScreenX() + dragPosition.x);
            stage.setY(e.getScreenY() + dragPosition.y);
        });
    }

    private void showMessage(String message, Color color) {
        if (this.errorLabel == null) {
            this.errorLabel = new Label();
            this.errorLabel.setStyle("-fx-font-size: 13px; -fx-text-alignment: center;");
            this.errorLabel.setMaxWidth(300.0);
            this.errorLabel.setWrapText(true);
            this.loginBox.getChildren().add((Object)this.errorLabel);
        }
        this.errorLabel.setTextFill((Paint)color);
        this.errorLabel.setText(message);
        this.errorLabel.setVisible(true);
    }

    private void showError(String message) {
        this.showMessage(message, Color.RED);
    }

    private void showInfo(String message) {
        this.showMessage(message, Color.LIGHTGREEN);
    }

    private void navigateToMainPage(Stage stage, AuthResponse authResponse) {
        try {
            FXMLLoader loader = new FXMLLoader();
            loader.setLocation(((Object)((Object)this)).getClass().getResource("/fxml/MainPage.fxml"));
            Parent root = (Parent)loader.load();
            MainPageController controller = (MainPageController)loader.getController();
            controller.setStage(stage);
            controller.initializeSession(authResponse);
            Scene scene = new Scene(root);
            scene.setFill((Paint)Color.TRANSPARENT);
            stage.setScene(scene);
            stage.setWidth(1200.0);
            stage.setHeight(700.0);
        }
        catch (Exception ex) {
            System.err.println("MainPage y\u00fcklenemedi: " + ex.getMessage());
            this.showError("Sayfa y\u00fcklenemedi!");
        }
    }

    private void styleField(TextField field, String prompt) {
        field.setPromptText(prompt);
        field.setMaxWidth(320.0);
        field.setPrefHeight(50.0);
        field.setStyle("-fx-background-color: rgba(40,40,40,0.8); -fx-background-radius: 12; -fx-text-fill: #ffffff; -fx-prompt-text-fill: rgba(255,255,255,0.4); -fx-font-size: 14px; -fx-padding: 0 15 0 15; -fx-border-color: rgba(255,255,255,0.1); -fx-border-radius: 12; -fx-border-width: 1;");
        field.setOnMouseEntered(e -> field.setStyle("-fx-background-color: rgba(50,50,50,0.9); -fx-background-radius: 12; -fx-text-fill: #ffffff; -fx-prompt-text-fill: rgba(255,255,255,0.4); -fx-font-size: 14px; -fx-padding: 0 15 0 15; -fx-border-color: rgba(255,107,61,0.4); -fx-border-radius: 12; -fx-border-width: 1.5;"));
        field.setOnMouseExited(e -> field.setStyle("-fx-background-color: rgba(40,40,40,0.8); -fx-background-radius: 12; -fx-text-fill: #ffffff; -fx-prompt-text-fill: rgba(255,255,255,0.4); -fx-font-size: 14px; -fx-padding: 0 15 0 15; -fx-border-color: rgba(255,255,255,0.1); -fx-border-radius: 12; -fx-border-width: 1;"));
    }

    private void checkForUpdatesAsync() {
        new Thread(() -> {
            try {
                System.out.println("[UPDATE] G\u00fcncelleme kontrol\u00fc ba\u015flat\u0131l\u0131yor...");
                boolean updateSuccess = UpdateManager.checkForUpdates();
                Platform.runLater(() -> {
                    if (!updateSuccess) {
                        System.out.println("[UPDATE] G\u00fcncelleme kontrol\u00fc ba\u015far\u0131s\u0131z - devam ediliyor");
                    } else {
                        System.out.println("[UPDATE] G\u00fcncelleme kontrol\u00fc tamamland\u0131");
                    }
                });
            }
            catch (Exception e) {
                System.err.println("[UPDATE] G\u00fcncelleme kontrol\u00fc hatas\u0131: " + e.getMessage());
            }
        }).start();
    }

    private static class DragPosition {
        double x;
        double y;

        private DragPosition() {
        }
    }
}

