/*
 * Decompiled with CFR 0.152.
 */
package piksora.server;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;

public class ApiServer {
    private static HttpServer server;
    private static int PORT;
    private static boolean isRunning;
    private static final String LAUNCHER_VERSION = "1.0.1";
    private static final String CLIENT_VERSION = "1.0.1";

    static {
        PORT = 8080;
        isRunning = false;
    }

    public static void start() {
        if (isRunning) {
            System.out.println("[API-SERVER] Server zaten \u00e7al\u0131\u015f\u0131yor!");
            return;
        }
        try {
            server = HttpServer.create(new InetSocketAddress(PORT), 0);
            server.createContext("/api/updates", new UpdatesHandler());
            server.createContext("/api/anticheat/validate", new AntiCheatHandler());
            server.setExecutor(null);
            server.start();
            isRunning = true;
            System.out.println("[API-SERVER] \u2713 API Server ba\u015flat\u0131ld\u0131: http://localhost:" + PORT);
            System.out.println("[API-SERVER]   - GET /api/updates");
            System.out.println("[API-SERVER]   - GET /api/anticheat/validate");
        }
        catch (IOException e) {
            System.err.println("[API-SERVER] Server ba\u015flat\u0131lamad\u0131: " + e.getMessage());
        }
    }

    public static void stop() {
        if (server != null && isRunning) {
            server.stop(0);
            isRunning = false;
            System.out.println("[API-SERVER] Server durduruldu");
        }
    }

    public static void setPort(int port) {
        PORT = port;
    }

    private static void sendResponse(HttpExchange exchange, int statusCode, String response) throws IOException {
        byte[] bytes = response.getBytes(StandardCharsets.UTF_8);
        exchange.sendResponseHeaders(statusCode, bytes.length);
        Throwable throwable = null;
        Object var5_6 = null;
        try (OutputStream os = exchange.getResponseBody();){
            os.write(bytes);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static boolean isRunning() {
        return isRunning;
    }

    public static int getPort() {
        return PORT;
    }

    static class AntiCheatHandler
    implements HttpHandler {
        AntiCheatHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            if (!"GET".equals(exchange.getRequestMethod())) {
                ApiServer.sendResponse(exchange, 405, "{\"error\":\"Method Not Allowed\"}");
                return;
            }
            exchange.getResponseHeaders().set("Access-Control-Allow-Origin", "*");
            exchange.getResponseHeaders().set("Content-Type", "application/json");
            String json = "{\"status\":\"valid\",\"timestamp\":" + System.currentTimeMillis() + "}";
            ApiServer.sendResponse(exchange, 200, json);
            System.out.println("[API-SERVER] GET /api/anticheat/validate - \u2713 Valid");
        }
    }

    static class UpdatesHandler
    implements HttpHandler {
        UpdatesHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            if (!"GET".equals(exchange.getRequestMethod())) {
                ApiServer.sendResponse(exchange, 405, "{\"error\":\"Method Not Allowed\"}");
                return;
            }
            exchange.getResponseHeaders().set("Access-Control-Allow-Origin", "*");
            exchange.getResponseHeaders().set("Content-Type", "application/json");
            String json = String.format("{\n  \"launcher_version\": \"%s\",\n  \"client_version\": \"%s\",\n  \"launcher_download_url\": \"http://localhost:%d/downloads/launcher.jar\",\n  \"client_download_url\": \"http://localhost:%d/downloads/client.jar\"\n}", "1.0.1", "1.0.1", PORT, PORT);
            ApiServer.sendResponse(exchange, 200, json);
            System.out.println("[API-SERVER] GET /api/updates - Launcher: 1.0.1, Client: 1.0.1");
        }
    }
}

