/*
 * Decompiled with CFR 0.152.
 */
package piksora.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLException;

public class UpdateManager {
    private static final String UPDATE_SERVER_URL = "https://piksora.com/api/updates";
    private static final String LAUNCHER_VERSION_FILE = "launcher_version.properties";
    private static final String CLIENT_VERSION_FILE = "client_version.properties";
    private static final String BACKUP_SUFFIX = ".backup";
    private static final String FALLBACK_LAUNCHER_FILE = "launcher.jar";
    private static String currentLauncherVersion = "1.0.2";
    private static String currentClientVersion = "1.0.0";
    private static final Path DETECTED_LAUNCHER_PATH = UpdateManager.detectCurrentLauncherPath();

    public static boolean checkForUpdates() {
        UpdateInfo updateInfo;
        block6: {
            System.out.println("[UPDATE] G\u00fcncelleme kontrol\u00fc ba\u015flat\u0131l\u0131yor...");
            try {
                UpdateManager.loadCurrentVersions();
                updateInfo = UpdateManager.fetchUpdateInfo();
                if (updateInfo != null) break block6;
                System.out.println("[UPDATE] \u26a0 Sunucuya ba\u011flan\u0131lamad\u0131 - offline mod");
                return true;
            }
            catch (Exception e) {
                System.err.println("[UPDATE] Hata: " + e.getMessage());
                return true;
            }
        }
        boolean needsUpdate = false;
        if (UpdateManager.isNewerVersion(updateInfo.getLauncherVersion(), currentLauncherVersion)) {
            System.out.println("[UPDATE] \ud83d\udd04 Launcher g\u00fcncellemesi bulundu: " + currentLauncherVersion + " -> " + updateInfo.getLauncherVersion());
            needsUpdate = true;
        }
        if (UpdateManager.isNewerVersion(updateInfo.getClientVersion(), currentClientVersion)) {
            System.out.println("[UPDATE] \ud83d\udd04 Client g\u00fcncellemesi bulundu: " + currentClientVersion + " -> " + updateInfo.getClientVersion());
            needsUpdate = true;
        }
        if (needsUpdate) {
            System.out.println("[UPDATE] \u2728 G\u00fcncellemeler mevcut!");
            return UpdateManager.performUpdate(updateInfo);
        }
        System.out.println("[UPDATE] \u2713 T\u00fcm dosyalar g\u00fcncel");
        return true;
    }

    private static void loadCurrentVersions() {
        try {
            File clientFile;
            Throwable throwable;
            File launcherFile = new File(LAUNCHER_VERSION_FILE);
            if (launcherFile.exists()) {
                Properties props = new Properties();
                Throwable throwable2 = null;
                throwable = null;
                try (FileInputStream fis = new FileInputStream(launcherFile);){
                    props.load(fis);
                    currentLauncherVersion = props.getProperty("version", "1.0.0");
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            if ((clientFile = new File(CLIENT_VERSION_FILE)).exists()) {
                Properties props = new Properties();
                throwable = null;
                Object var4_8 = null;
                try (FileInputStream fis = new FileInputStream(clientFile);){
                    props.load(fis);
                    currentClientVersion = props.getProperty("version", "1.0.0");
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            System.out.println("[UPDATE] Mevcut versiyonlar - Launcher: " + currentLauncherVersion + ", Client: " + currentClientVersion);
        }
        catch (Exception e) {
            System.err.println("[UPDATE] Versiyon dosyalar\u0131 okunamad\u0131: " + e.getMessage());
        }
    }

    private static UpdateInfo fetchUpdateInfo() {
        int responseCode;
        HttpURLConnection conn;
        block32: {
            System.out.println("[UPDATE] Ba\u011flan\u0131l\u0131yor: https://piksora.com/api/updates");
            URL url = new URL(UPDATE_SERVER_URL);
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(10000);
            conn.setReadTimeout(10000);
            conn.setRequestProperty("User-Agent", "PiksoraLauncher/" + currentLauncherVersion);
            conn.setRequestProperty("Accept", "application/json");
            responseCode = conn.getResponseCode();
            System.out.println("[UPDATE] HTTP Response Code: " + responseCode);
            if (responseCode != 200) break block32;
            StringBuilder response = new StringBuilder();
            Throwable throwable = null;
            Object var5_17 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));){
                String line;
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            String json = response.toString();
            System.out.println("[UPDATE] Sunucu yan\u0131t\u0131 al\u0131nd\u0131: " + json.substring(0, Math.min(100, json.length())) + "...");
            UpdateInfo info = UpdateManager.parseUpdateInfo(json);
            if (info != null) {
                System.out.println("[UPDATE] \u2713 G\u00fcncelleme bilgileri ba\u015far\u0131yla al\u0131nd\u0131");
                return info;
            }
            System.err.println("[UPDATE] \u2717 JSON parse ba\u015far\u0131s\u0131z");
            return null;
        }
        try {
            try {
                Throwable response = null;
                Object var4_15 = null;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getErrorStream(), "UTF-8"));){
                    String line;
                    StringBuilder errorResponse = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        errorResponse.append(line);
                    }
                    System.err.println("[UPDATE] \u2717 Sunucu hatas\u0131 (" + responseCode + "): " + errorResponse.toString());
                }
                catch (Throwable throwable) {
                    if (response == null) {
                        response = throwable;
                    } else if (response != throwable) {
                        response.addSuppressed(throwable);
                    }
                    throw response;
                }
            }
            catch (Exception ex) {
                System.err.println("[UPDATE] \u2717 Sunucu hatas\u0131: " + responseCode);
            }
            return null;
        }
        catch (SocketTimeoutException e) {
            System.err.println("[UPDATE] \u2717 Ba\u011flant\u0131 zaman a\u015f\u0131m\u0131 (timeout): https://piksora.com/api/updates");
            System.err.println("[UPDATE]   L\u00fctfen internet ba\u011flant\u0131n\u0131z\u0131 kontrol edin");
            return null;
        }
        catch (ConnectException e) {
            System.err.println("[UPDATE] \u2717 Sunucuya ba\u011flan\u0131lamad\u0131: " + e.getMessage());
            System.err.println("[UPDATE]   URL: https://piksora.com/api/updates");
            System.err.println("[UPDATE]   L\u00fctfen hosting'inizin \u00e7al\u0131\u015ft\u0131\u011f\u0131ndan emin olun");
            return null;
        }
        catch (UnknownHostException e) {
            System.err.println("[UPDATE] \u2717 Host bulunamad\u0131: " + e.getMessage());
            System.err.println("[UPDATE]   URL: https://piksora.com/api/updates");
            System.err.println("[UPDATE]   L\u00fctfen domain'in do\u011fru oldu\u011fundan emin olun");
            return null;
        }
        catch (SSLException e) {
            System.err.println("[UPDATE] \u2717 SSL sertifika hatas\u0131: " + e.getMessage());
            System.err.println("[UPDATE]   HTTPS ba\u011flant\u0131s\u0131nda sorun olabilir");
            return null;
        }
        catch (IOException e) {
            System.err.println("[UPDATE] \u2717 IO hatas\u0131: " + e.getMessage());
            System.err.println("[UPDATE]   URL: https://piksora.com/api/updates");
            return null;
        }
        catch (Exception e) {
            System.err.println("[UPDATE] \u2717 Beklenmeyen hata: " + e.getClass().getSimpleName());
            System.err.println("[UPDATE]   Mesaj: " + e.getMessage());
            if (e.getCause() != null) {
                System.err.println("[UPDATE]   Sebep: " + e.getCause().getMessage());
            }
            return null;
        }
    }

    private static UpdateInfo parseUpdateInfo(String json) {
        try {
            String launcherVersion = UpdateManager.extractValue(json, "launcher_version");
            String clientVersion = UpdateManager.extractValue(json, "client_version");
            String launcherUrl = UpdateManager.extractValue(json, "launcher_download_url");
            String clientUrl = UpdateManager.extractValue(json, "client_download_url");
            if (launcherUrl != null) {
                launcherUrl = launcherUrl.replace("\\/", "/").replace("\\\"", "\"").replace("\\\\", "\\");
            }
            if (clientUrl != null) {
                clientUrl = clientUrl.replace("\\/", "/").replace("\\\"", "\"").replace("\\\\", "\\");
            }
            System.out.println("[UPDATE] Temizlenmi\u015f URL'ler:");
            System.out.println("[UPDATE]   Launcher: " + launcherUrl);
            System.out.println("[UPDATE]   Client: " + clientUrl);
            return new UpdateInfo(launcherVersion, clientVersion, launcherUrl, clientUrl);
        }
        catch (Exception e) {
            System.err.println("[UPDATE] JSON parse hatas\u0131: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    private static String extractValue(String json, String key) {
        try {
            String pattern = "\"" + key + "\"\\s*:\\s*\"((?:[^\"\\\\]|\\\\.)*)\"";
            Pattern p = Pattern.compile(pattern);
            Matcher m = p.matcher(json);
            if (m.find()) {
                return m.group(1);
            }
            return null;
        }
        catch (Exception e) {
            System.err.println("[UPDATE] extractValue hatas\u0131 (" + key + "): " + e.getMessage());
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isNewerVersion(String newVersion, String currentVersion) {
        if (newVersion == null || currentVersion == null) {
            return false;
        }
        try {
            String[] newParts = newVersion.split("\\.");
            String[] currentParts = currentVersion.split("\\.");
            int maxLength = Math.max(newParts.length, currentParts.length);
            int i = 0;
            while (true) {
                int currentPart;
                if (i >= maxLength) {
                    return false;
                }
                int newPart = i < newParts.length ? Integer.parseInt(newParts[i]) : 0;
                int n = currentPart = i < currentParts.length ? Integer.parseInt(currentParts[i]) : 0;
                if (newPart > currentPart) {
                    return true;
                }
                if (newPart < currentPart) {
                    return false;
                }
                ++i;
            }
        }
        catch (Exception e) {
            System.err.println("[UPDATE] Versiyon kar\u015f\u0131la\u015ft\u0131rma hatas\u0131: " + e.getMessage());
            return false;
        }
    }

    private static boolean performUpdate(UpdateInfo updateInfo) {
        block15: {
            boolean launcherSuccess;
            block14: {
                boolean clientSuccess;
                block13: {
                    System.out.println("[UPDATE] G\u00fcncellemeler indiriliyor...");
                    try {
                        launcherSuccess = true;
                        clientSuccess = true;
                        boolean launcherNeeded = false;
                        boolean clientNeeded = false;
                        if (UpdateManager.isNewerVersion(updateInfo.getLauncherVersion(), currentLauncherVersion)) {
                            launcherNeeded = true;
                            System.out.println("[UPDATE] Launcher g\u00fcncellemesi gerekiyor...");
                            if (!UpdateManager.downloadAndInstall(updateInfo.getLauncherUrl(), UpdateManager.getLauncherTargetFileName())) {
                                launcherSuccess = false;
                                System.err.println("[UPDATE] \u2717 Launcher g\u00fcncellemesi ba\u015far\u0131s\u0131z!");
                            } else {
                                UpdateManager.saveVersion(LAUNCHER_VERSION_FILE, updateInfo.getLauncherVersion());
                                System.out.println("[UPDATE] \u2713 Launcher g\u00fcncellemesi tamamland\u0131!");
                            }
                        }
                        if (UpdateManager.isNewerVersion(updateInfo.getClientVersion(), currentClientVersion)) {
                            clientNeeded = true;
                            System.out.println("[UPDATE] Client g\u00fcncellemesi gerekiyor...");
                            if (!UpdateManager.downloadAndInstall(updateInfo.getClientUrl(), "client.jar")) {
                                clientSuccess = false;
                                System.err.println("[UPDATE] \u2717 Client g\u00fcncellemesi ba\u015far\u0131s\u0131z!");
                            } else {
                                UpdateManager.saveVersion(CLIENT_VERSION_FILE, updateInfo.getClientVersion());
                                System.out.println("[UPDATE] \u2713 Client g\u00fcncellemesi tamamland\u0131!");
                            }
                        }
                        if (!launcherSuccess || !clientSuccess) break block13;
                        if (launcherNeeded || clientNeeded) {
                            System.out.println("[UPDATE] \u2713 T\u00fcm g\u00fcncellemeler ba\u015far\u0131yla tamamland\u0131!");
                        } else {
                            System.out.println("[UPDATE] \u2713 G\u00fcncelleme kontrol\u00fc tamamland\u0131");
                        }
                        return true;
                    }
                    catch (Exception e) {
                        System.err.println("[UPDATE] \u2717 G\u00fcncelleme hatas\u0131: " + e.getMessage());
                        e.printStackTrace();
                        return false;
                    }
                }
                if (!clientSuccess) break block14;
                System.out.println("[UPDATE] \u26a0 Client g\u00fcncellemesi ba\u015far\u0131l\u0131, launcher g\u00fcncellemesi atland\u0131 (404 - dosya bulunamad\u0131)");
                System.out.println("[UPDATE]   Not: Launcher dosyas\u0131 hosting'de bulunamad\u0131, client g\u00fcncellendi");
                return true;
            }
            if (!launcherSuccess) break block15;
            System.out.println("[UPDATE] \u26a0 Launcher g\u00fcncellemesi ba\u015far\u0131l\u0131, client g\u00fcncellemesi atland\u0131 (404 - dosya bulunamad\u0131)");
            System.out.println("[UPDATE]   Not: Client dosyas\u0131 hosting'de bulunamad\u0131, launcher g\u00fcncellendi");
            return true;
        }
        System.err.println("[UPDATE] \u2717 T\u00fcm g\u00fcncellemeler ba\u015far\u0131s\u0131z!");
        System.err.println("[UPDATE]   L\u00fctfen hosting'deki dosyalar\u0131n mevcut oldu\u011fundan emin olun");
        return false;
    }

    private static boolean downloadAndInstall(String downloadUrl, String fileName) {
        boolean backupCreated;
        Path tempPath;
        Path backupPath;
        Path targetPath;
        block26: {
            HttpURLConnection conn;
            block24: {
                block23: {
                    if (downloadUrl != null && !downloadUrl.trim().isEmpty()) break block23;
                    System.err.println("[UPDATE] \u2717 \u0130ndirme URL'i bo\u015f!");
                    return false;
                }
                try {
                    downloadUrl = downloadUrl.replace("\\/", "/").replace("\\\"", "\"").trim();
                    System.out.println("[UPDATE] \u0130ndiriliyor: " + downloadUrl);
                    URL url = new URL(downloadUrl);
                    conn = (HttpURLConnection)url.openConnection();
                    conn.setRequestMethod("GET");
                    conn.setConnectTimeout(10000);
                    conn.setReadTimeout(30000);
                    int responseCode = conn.getResponseCode();
                    if (responseCode == 200) break block24;
                    if (responseCode == 404) {
                        System.err.println("[UPDATE] \u2717 Dosya bulunamad\u0131 (404): " + downloadUrl);
                        System.err.println("[UPDATE]   L\u00fctfen hosting'de bu dosyan\u0131n mevcut oldu\u011fundan emin olun");
                    } else {
                        System.err.println("[UPDATE] \u2717 \u0130ndirme hatas\u0131 (" + responseCode + "): " + downloadUrl);
                        try {
                            String line;
                            BufferedReader errorReader = new BufferedReader(new InputStreamReader(conn.getErrorStream(), "UTF-8"));
                            StringBuilder errorResponse = new StringBuilder();
                            while ((line = errorReader.readLine()) != null) {
                                errorResponse.append(line);
                            }
                            if (errorResponse.length() > 0) {
                                System.err.println("[UPDATE]   Hata detay\u0131: " + errorResponse.toString().substring(0, Math.min(200, errorResponse.length())));
                            }
                        }
                        catch (Exception errorReader) {
                            // empty catch block
                        }
                    }
                    return false;
                }
                catch (Exception e) {
                    System.err.println("[UPDATE] \u0130ndirme hatas\u0131: " + e.getMessage());
                    return false;
                }
            }
            targetPath = Paths.get(fileName, new String[0]).toAbsolutePath();
            backupPath = Paths.get(String.valueOf(fileName) + BACKUP_SUFFIX, new String[0]).toAbsolutePath();
            tempPath = Files.createTempFile("piksora-update-", ".tmp", new FileAttribute[0]);
            Throwable throwable = null;
            Object var9_16 = null;
            try (InputStream in = conn.getInputStream();){
                Files.copy(in, tempPath, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            backupCreated = false;
            if (!Files.exists(targetPath, new LinkOption[0])) break block26;
            try {
                Files.move(targetPath, backupPath, StandardCopyOption.REPLACE_EXISTING);
                backupCreated = true;
                System.out.println("[UPDATE] Eski dosya yedeklendi: " + backupPath.getFileName());
            }
            catch (FileSystemException lockEx) {
                System.err.println("[UPDATE] Eski dosya ta\u015f\u0131namad\u0131 (muhtemelen kullan\u0131mda): " + lockEx.getMessage());
                System.err.println("[UPDATE] G\u00fcncel dosya " + tempPath.getFileName() + " olarak indirildi. L\u00fctfen manuel olarak de\u011fi\u015ftirin.");
                return false;
            }
        }
        Files.move(tempPath, targetPath, StandardCopyOption.REPLACE_EXISTING);
        System.out.println("[UPDATE] \u2713 \u0130ndirme tamamland\u0131 ve dosya g\u00fcncellendi: " + targetPath.getFileName());
        if (backupCreated) {
            Files.deleteIfExists(backupPath);
            System.out.println("[UPDATE] Eski s\u00fcr\u00fcm silindi (ayn\u0131 dosya kullan\u0131l\u0131yor).");
        }
        return true;
    }

    private static Path detectCurrentLauncherPath() {
        try {
            Path path;
            URL location = UpdateManager.class.getProtectionDomain().getCodeSource().getLocation();
            if (location != null && "file".equalsIgnoreCase(location.getProtocol()) && Files.isRegularFile(path = Paths.get(location.toURI()).toAbsolutePath(), new LinkOption[0]) && path.toString().toLowerCase().endsWith(".jar")) {
                System.out.println("[UPDATE] \u00c7al\u0131\u015fan launcher yolu alg\u0131land\u0131: " + path);
                return path;
            }
        }
        catch (Exception e) {
            System.err.println("[UPDATE] Launcher yolu alg\u0131lanamad\u0131: " + e.getMessage());
        }
        return null;
    }

    private static String getLauncherTargetFileName() {
        if (DETECTED_LAUNCHER_PATH != null) {
            return DETECTED_LAUNCHER_PATH.toString();
        }
        return FALLBACK_LAUNCHER_FILE;
    }

    private static void saveVersion(String fileName, String version) {
        try {
            Properties props = new Properties();
            props.setProperty("version", version);
            props.setProperty("updated_at", String.valueOf(System.currentTimeMillis()));
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileOutputStream fos = new FileOutputStream(fileName);){
                props.store(fos, "Version information");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            System.out.println("[UPDATE] Versiyon kaydedildi: " + fileName + " = " + version);
        }
        catch (Exception e) {
            System.err.println("[UPDATE] Versiyon kaydetme hatas\u0131: " + e.getMessage());
        }
    }

    public static void forceUpdateCheck() {
        System.out.println("[UPDATE] Manuel g\u00fcncelleme kontrol\u00fc ba\u015flat\u0131l\u0131yor...");
        UpdateManager.checkForUpdates();
    }

    public static String getCurrentLauncherVersion() {
        return currentLauncherVersion;
    }

    public static String getCurrentClientVersion() {
        return currentClientVersion;
    }

    public static class UpdateInfo {
        private final String launcherVersion;
        private final String clientVersion;
        private final String launcherUrl;
        private final String clientUrl;

        public UpdateInfo(String launcherVersion, String clientVersion, String launcherUrl, String clientUrl) {
            this.launcherVersion = launcherVersion;
            this.clientVersion = clientVersion;
            this.launcherUrl = launcherUrl;
            this.clientUrl = clientUrl;
        }

        public String getLauncherVersion() {
            return this.launcherVersion;
        }

        public String getClientVersion() {
            return this.clientVersion;
        }

        public String getLauncherUrl() {
            return this.launcherUrl;
        }

        public String getClientUrl() {
            return this.clientUrl;
        }
    }
}

